% Resistors.m - Greg Bucks - 10/8/2013
% Description: this script will compute the equivalent resistance for a set
% of resistors in series or parallel.  The script will prompt the user for
% the type of connection and the number of resistors and display the
% equivalent resistance.
% Usage: >> Resistors;

% prompt user for values and ensure number of resistors is appropriate
connection = menu('Select the connection type:','Series','Parallel');
if connection ~= 1 && connection ~= 2
    error('You did not make a valid selection for connection type!');
end

number_resistors = 0;
while number_resistors < 1 || mod(number_resistors,1) > 0
    number_resistors = input('Please enter the number of resistors: ');
    if number_resistors < 1
        fprintf('You must enter a positive value for the number of resistors.\n');
    elseif mod(number_resistors,1) > 0
        fprintf('You must have an integer number of resistors.\n');
    end
end

% compute the equivalent resistance
equivalent_resistance = 0;
for k = 1:number_resistors
    resistor = -1;
    while resistor < 0
        resistor = input('Please enter the resistor value: ');
        if resistor < 0
            fprintf('The resistance must be non-negative.  Please try again.\n');
        end
    end
    switch connection
        case 1  % series connection
            equivalent_resistance = equivalent_resistance + resistor;
        case 2  % parallel connection
            equivalent_resistance = equivalent_resistance + 1/resistor;
    end
end
if connection == 2
    equivalent_resistance = 1/equivalent_resistance;
end

% display results
fprintf('The equivalent resistance is: %0.4f Ohms.\n',equivalent_resistance);